<?php
/*
  Copyright 2018 Lightning2014(https://lightning2014.ensyutsubu.com/blog/)

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

if(!defined('LTG_THUMBLINK_VER')) define(LTG_THUMBLINK_VER , '2.0.3'); //バージョン情報（変更不可）

/* サムネイルリンク
  要 PHP 5 以上 WordPress 2.8以上
  要 GDモジュール
  powered by 勝手にライトニング！ https://lightning2014.ensyutsubu.com/blog/
*/

/* 流用設定 */
$arg = array(
  'cash_reflesh_mode' => false, //キャッシュを強制的に更新したい時はtrueにする
  'no_image' => '',  //サイトが存在しない時に出すサムネイル画像のURL（省略可）※画像サイズはサムネイルサイズに合わせてください
  'no_site_str' => 'ページがなくなった可能性があります。', //metaデータが取得出来なかった時にdiscriptionに表示する文言
  'cash_period' => 60, //キャッシュの有効期限（日）
  'image_mag' => 2, //画像取得時の倍率 ratina用に2倍が現在のところ基本
  'thumbnail_width' => 160, //スナップショットの横幅 及び サムネイルの横幅設定
  'thumbnail_height' => 90, //スナップショットの縦幅
  'separation' => ' - ', //タイトルとサイト名の間を区切る文字（ただしOGPタイトルがない場合は対象サイトに合わせる）
  'mysite_name' => false, //タイトル欄に自分のサイト名を付け加えるかどうか
  'theme' => 'Cocoon', //WordPressのテーマを指定（今の所Cocoonのみ対応）
  /* PostSnippetsのVariablesを取得 */
  'ogpimg' => '{ogp}',
  'siteurl' => '{url}',
  'sitetitle' => '{title}',
  'boxtitle' => '{boxtitle}',
  'aflink' => '{af_link}',
  'card_str' => '{blogcard}',
);

/* テーマのブログカードに合わせた出力関数 */
/* lightning_theme_card_XXX (XXXは小文字で) で登録すれば追加できます*/
if(!function_exists('lightning_theme_card_cocoon')){
  function lightning_theme_card_cocoon($url,$title=''){
    /* Cocoon仕様 */
    $tag = '';
    $tag .= "\n";
    $tag .= '<a href="'.$url.'">'; // このリンクはCocoonでは意味がないようです
    $tag .= $url;
    $tag .= "</a>\n";

    return $tag;
  }
}
/* テーマのブログカードのフォーマットを出力する関数 */
/* lightning_tagbox_XXX (XXXは小文字で) で登録すれば追加できます*/
if(!function_exists('lightning_tagbox_cocoon')){
  function lightning_tagbox_cocoon($cash,$config,$inner_check = false){

    /* ----------- 使える変数 -----------
    $cash['url']  - ターゲットのURL
    $cash['name'] - ターゲットのサイト名
    $cash'[title'] - タイトル
    $cash['desc'] - discription
    $cash['image'] - OGP image URL（オリジナル）
    $cash['width'] - OGP image の横幅（オリジナル）
    $cash['height'] - OGP image の縦幅（オリジナル
    $cash['domain'] - ターゲットのドメイン
    $cash['cash_img'] - キャッシュされた画像のURL
    $cash['cash_imgw'] - キャッシュされた画像の横幅
    $cash['cash_imgh'] - キャッシュされた画像の縦幅
    $cash['date'] - 投稿日
    ※全てのデータが取得できているとは限りません
    --------------------------------- */
    /* Cocoon 仕様 */
    $tag_img = '<figure class="blogcard-thumbnail '.($inner_check ? 'internal-blogcard-thumbnail' : 'external-blogcard-thumbnail').'">';
    $tag_img .= '<img src="'.$cash['cash_img'].'" alt="" ';
    $tag_img .= 'class="blogcard-thumb-image '.($inner_check ? 'internal' : 'external').'-blogcard-thumb-image" width="'.$config['thumbnail_width'].'" height="'.$config['thumbnail_height'].'" />';
    $tag_img .= '</figure>';

    $tag_title = '<div class="blogcard-title '.($inner_check ? 'internal' : 'external').'-blogcard-title">'.$cash['title'].'</div>';

    $tag_snipet = '<div class="blogcard-snipet '.($inner_check ? 'internal' : 'external').'-blogcard-snipet">'.$cash['desc'].'</div>';

    $tag_favicon = '<div class="blogcard-favicon '.($inner_check ? 'internal' : 'external').'-blogcard-favicon">';
    $tag_favicon .= '<img src="//www.google.com/s2/favicons?domain='.$cash['domain'].'" class="blogcard-favicon-image';
    $tag_favicon .= ($inner_check ? ' internal-blogcard-favicon-image' : '').'" alt="" width="16" height="16" />';
    $tag_favicon .= '</div>';

    $tag_domain = '<div class="blogcard-domain '.($inner_check ? 'internal' : 'external').'-blogcard-domain">'.$cash['domain'].'</div>';

    $tag_date = '<div class="blogcard-post-date internal-blogcard-post-date">'.$cash['date'].'</div>';

    $tag_container = '<a href="'.$cash['url'].'" title="'.$cash['title'].'" class="blogcard-wrap '.($inner_check ? 'internal' : 'external').'-blogcard-wrap a-wrap cf" target="_blank">';
    $tag_container .= '<div class="blogcard '.($inner_check ? 'internal' : 'external').'-blogcard ib-left cf">';
    $tag_container .= $tag_img;
    $tag_container .= '<div class="blogcard-content '.($inner_check ? 'internal' : 'external').'-blogcard-content">';
    $tag_container .= $tag_title;
    $tag_container .= $tag_snipet;
    $tag_container .= '</div>';
    $tag_container .= '<div class="blogcard-footer '.($inner_check ? 'internal' : 'external').'-blogcard-footer cf">';
    $tag_container .= '<div class="blogcard-site '.($inner_check ? 'internal' : 'external').'-blogcard-site">';
    $tag_container .= $tag_favicon;
    $tag_container .= $tag_domain;
    $tag_container .= '</div>';
    if($inner_check){
      $tag_container .= '<div class="blogcard-date internal-blogcard-date">';
      $tag_container .= $tag_date;
      $tag_container .= '</div>';
    }
    $tag_container .= '</div></div></a>';

    return $tag_container;
  }
}

//サムネイルリンク全体のラッピング関数
if(!function_exists('lightning_thumblink_container')){
  function lightning_thumblink_container($tag_box, $config){
    $cont = '';
    $cont .= "\n<!-- サムネイルリンク (for Theme ".$config['theme'].") ver.".$config['ver']." -->\n";
    $cont .= '<div class="ltng_thumlinkbox_container"><div class="ltng_thumlinkbox"><div class="ltng_afbox">';
    if($config['boxtitle']){
      $cont .= '<div class ="thumlinkbox_title">'.$config['boxtitle'];
      if($config['aflink']){
        $cont .= '<div class="ltng_aflink">'.$config['aflink'].'</div>';
      }
      $cont .= '</div>';
    }elseif($config['aflink']){
      $cont .= '<div class ="thumlinkbox_title"><div class="ltng_aflink">'.$config['aflink'].'</div></div>';
    }
    $cont .= $tag_box;
    $cont .= '</div><div class="ltng_signature"><a href="https://lightning2014.ensyutsubu.com/blog/page-8469/" target="_blank" rel="noopener">powered by サムネイルリンク ver.'.$config['ver'].'</a></div></div></div>';
    return $cont;
  }
}


/* サムネイルリンクの機能をまとめたクラス */
if(!class_exists('Ltg_Thumblink')):
class Ltg_Thumblink {

  public $url = NULL; //対象URL
  public $domain = NULL; //対象サイトのドメイン
  public $inner_check = NULL; //内部リンクかどうかのチェック
  public $id = NULL; //内部リンクの場合の記事ID
  public $html = NULL; //$urlから取得したHTML格納
  public $meta = NULL; //メタ情報格納
  public $config = NULL; //設定情報
  public $hash = NULL; //URLから作られるハッシュ
  public $cash = NULL; //書き込まれたキャッシュ

  /* HTML取得メソッド */
  public function get_html($url = NULL, $args = NULL){
    if($url === NULL){//引数省略されている場合プロパティを使う
      if($this->url === NULL) return false;
      $url = $this->url;
    }

    $ua = $_SERVER['HTTP_USER_AGENT']; //ユーザーエージェントを取得
    if(strpos($ua,$this->config['user_agent']) !== false) return false;

    global $wp_version;
    $http = (is_ssl() ? 'https' : 'http') . '://';
    $this_url = $http . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"];
    $tmpargs = array( //$argsが省略されている場合
      'timeout'     => 10,
      'redirection' => 5,
      'sslverify'   => false,
    );
    if(!$args) $args = $tmpargs;
    $args['user-agent'] = 'WordPress/' . $wp_version . '; ' . this_url.'; '.$this->config['user_agent'];

    $target = wp_remote_get( $url, $args ); //サイトを取得
    $response_code = wp_remote_retrieve_response_code($target);

    if(!is_wp_error($target) && $response_code === 200 ) {
      if(array_key_exists('body',$target)){
        $this->html = $target['body'];
        return $this->html;
      }
    }
    //失敗した場合cURLを試してみる
    if($response_code === 503) return false; //アクセス集中を防止
    $cu = curl_init();
    curl_setopt($cu, CURLOPT_URL, $url);
    curl_setopt($cu, 'WordPress/' . $wp_version . '; ' . this_url.'; '.$this->config['user_agent'] );
    curl_setopt($cu, CURLOPT_RETURNTRANSFER, true);
    $target_str = curl_exec($cu);
    curl_close($cu);
    if($target_str == false){
      $this->config['no_site_str'] .= '<br>response_code : '.$response_code;
      return false; //取得失敗の時はfalseを返す
    }
    $this->html = $target_str;
    return $this->html;
  }
  /* ハッシュ取得メソッド */
  public function get_hash($url = NULL){
    if($url === NULL){//引数省略されている場合プロパティを使う
      if($this->url === NULL) return false;
      $url = $this->url;
    }
    $hash = 'ltgcash_'.md5($url); //URLからハッシュ値を算出
    $this->hash = $hash;

    return $hash;
  }
  /* ドメイン取得メソッド */
  public function get_domain($url = NULL){
    if($url === NULL){//引数省略されている場合プロパティを使う
      if($this->url === NULL) return false;
      $url = $this->url;
    }
    return parse_url($url,PHP_URL_HOST);
  }

  /* 内部リンクかどうか確認するメソッド */
  public function check_inout($url = NULL){
    if($url === NULL){//引数省略されている場合プロパティを使う
      if($this->url === NULL) return NULL;
      $url = $this->url;
    }
    if(!$this->domain) $this->domain = $this->get_domain($url); //対象のドメイン
    $this->inner_check = ($this->domain == $_SERVER["HTTP_HOST"]) ? true : false; //内部リンクかどうかのチェック
    return $this->inner_check;
  }

  /* meta情報取得メソッド */
  public function get_metas($html = NULL){
    /* ------------------------------------------------
    html文字列からmeta情報を全て抜き取り
    meta['（nameなど）__（og:imageなど）'] = （contentの値）
    の形式を戻り値として返す関数。
    ※属性文字は小文字に統一されます。（値は区別）
    ex.
    例えばOGPをイメージ取得したい場合
    戻り値をmetaという配列に入れたい場合
    meta['property__og:image']
    から取り出すことができる。
    ------------------------------------------------ */
    if($html === NULL) $html = $this->html ? $this->html : $this->get_html($this->url);
    if($html == false) return false;
    $html = mb_convert_encoding($html,'UTF-8', 'auto'); //UTF-8以外の文字をUTF-8に変換

    preg_match_all('/<meta\s+([^\/>\s=]+)\s*=\s*(?:\"|\')([^\"\']*)(?:\"|\')(?:\s+([^\/>\s=]+)\s*=\s*(?:\"|\')([^\"\']*)(?:\"|\')\s*[^\/>\s=]*)*\s*\/*>/ui',$html,$row,PREG_SET_ORDER);
    $meta = array();
    for( $i = 0, $max = count($row); $i < $max ; $i++){
      if(count($row[$i]) == 3){ //contentのないmeta
        $meta[mb_strtolower($row[$i][1])] = $row[$i][2];
      } else { //contentがあるmeta
        if(mb_strtolower($row[$i][3]) == 'content'){
          $meta[mb_strtolower($row[$i][1]).'__'.mb_strtolower($row[$i][2])] = $row[$i][4];
        } else {
          $meta[mb_strtolower($row[$i][3]).'__'.mb_strtolower($row[$i][4])] = $row[$i][2];
        }
      }
    }
    $this->meta = $meta;
    return $meta;
  }
  /* OGP情報取得して配列で返す関数 */
  public function get_ogp($url = NULL,$inner_check = false){
    if($url === NULL){//引数省略されている場合プロパティを使う
      if($this->url === NULL) return false;
      $url = $this->url;
    }

    $target = $this->get_html($url); //body要素取得
    if($target === false) return false;

    $info = array( //情報格納配列の初期化
      'title' => null,       //通常のタイトル
      'desc' => null,        //通常のdescription
      'og_type' => null,     //OGPのページタイプ
      'og_url' => null,      //OGP URL
      'og_sitename' => null, //OGP サイトネーム
      'og_locale' => null,   //OGP サイトの国
      'og_title' => null,    //OGPタイトル
      'og_desc' => null,     //OGPのdescription
      'og_image' => null,    //OGPのimageURL
      'tw_url' => null,      //Twitterカード URL
      'tw_domain' => null,   //Twitterカード ドメイン
      'tw_card' => null,     //Twitterカードの種類
      'tw_title' => null,    //Twitterカードのタイトル
      'tw_desc' => null,     //Twitterカードのdescription
      'tw_image' => null,    //TwitterカードのimageURL
      'tw_creator' => null,  //Twitterカード アカウントのURL
      'tw_site' => null,     //Twitterカード サイトのURL
      'date' => null,        //ページ作成日（あまり設定されている事はない）
    );
    /* 通常タイトルの取得 */
    preg_match('/<title.*?>(.*?)<\/title.*?>/ui', $target, $matches);
    $info['title'] = $matches ? $matches[1] : null;

    $meta = $this->get_metas($target); //メタ情報を全部取得

    /* 通常のdescription取得 */
    if(array_key_exists('name__description',$meta)) $info['desc'] = $meta['name__description'];
    /* OGP ページタイプの取得 */
    if(array_key_exists('property__og:type',$meta)) $info['og_type'] = $meta['property__og:type'];
    /* OGP URLの取得（削除しても良いかも） */
    if(array_key_exists('property__og:url',$meta)) $info['og_url'] = $meta['property__og:url'];
    /* OGP サイトネームの取得 */
    if(array_key_exists('property__og:site_name',$meta)) $info['og_sitename'] = $meta['property__og:site_name'];
    /* OGP サイト国の取得 */
    if(array_key_exists('property__og:locale',$meta)) $info['og_locale'] = $meta['property__og:locale'];
    /* OGPタイトルの取得 */
    if(array_key_exists('property__og:title',$meta)) $info['og_title'] = $meta['property__og:title'];
    /* OGP descriptionの取得 */
    if(array_key_exists('property__og:description',$meta)) $info['og_desc'] = $meta['property__og:description'];
    /* OGP imageURLの取得 */
    if(array_key_exists('property__og:image',$meta)) $info['og_image'] = $meta['property__og:image'];
    /* Twitterカード URLの取得（削除しても良いかも） */
    if(array_key_exists('name__twitter:url',$meta)) $info['tw_url'] = $meta['name__twitter:url'];
    /* Twitterカード ドメインの取得（削除しても良いかも） */
    if(array_key_exists('name__twitter:domain',$meta)) $info['tw_domain'] = $meta['name__twitter:domain'];
    /* Twitterカードの種類の取得 */
    if(array_key_exists('name__twitter:card',$meta)) $info['tw_card'] = $meta['name__twitter:card'];
    /* Twitterカード タイトルの取得 */
    if(array_key_exists('name__twitter:title',$meta)) $info['tw_title'] = $meta['name__twitter:title'];
    /* Twitterカード descriptionの取得 */
    if(array_key_exists('name__twitter:description',$meta)) $info['tw_desc'] = $meta['name__twitter:description'];
    /* Twitterカード imageの取得 */
    if(array_key_exists('name__twitter:image',$meta)) $info['tw_image'] = $meta['name__twitter:image'];
    /* Twitterカード アカウントURLの取得 */
    if(array_key_exists('name__twitter:creator',$meta)) $info['tw_creator'] = $meta['name__twitter:creator'];
    /* Twitterカード サイトURLの取得 */
    if(array_key_exists('name__twitter:site',$meta)) $info['tw_site'] = $meta['name__twitter:site'];
    /* 作成日の取得 */
    $this->id = $inner_check ? url_to_postid( $url ) : NULL; //WordPressの記事IDを取得（TOPページやカテゴリページはIDがない）

    if($inner_check && $this->id){ //内部リンクかつIDが取得できる場合
      if($this->id) $info['date'] = get_the_date('Y.n.j',$this->id);

    } else { //外部リンクまたはIDが取得できなかった場合
      if(array_key_exists('name__creation_date',$meta)) $info['date'] = $meta['name__creation_date'];
      if(array_key_exists('name__creation date',$meta)) $info['date'] = $meta['name__creation date'];
      if(array_key_exists('name__creation-date',$meta)) $info['date'] = $meta['name__creation-date'];
      if(array_key_exists('property__article:published_time',$meta)) $info['date'] = $meta['property__article:published_time'];//「2018-06-18T13:34:16+00:00」のような形式？

      if($info['date']) $info['date'] = date('Y.n.j',strtotime($info['date'])); //一度timestampに変換して整形する
    }

    return $info;
  }

  /* オブジェクト初期化メソッド */
  public function init($url, $arg = NULL){
    if(!$url) return false;

    /* 設定の初期値 */
    $this->config = array(
      'cash_reflesh_mode' => false, //キャッシュを強制的に更新したい時はtrueにする
      'cash_period' => 30, //キャッシュの有効期限（日）
      'image_mag' => 2, //画像取得時の倍率 ratina用に2倍が現在のところ基本

      'dir_cash' => '/uploads/lightning-system/image-cash/', //画像cashの保存場所（基本的に変更しないで）
      'wp_snapshot_url' => 'https://s0.wordpress.com/mshots/v1/', //WordPressのSNAPSHOT APIアドレス
      'thumbnail_width' => 160, //スナップショットの横幅 及び サムネイルの横幅設定
      'thumbnail_height' => 90, //スナップショットの縦幅
      'no_image' => '',  //サイトが存在しない時に出すサムネイル画像のURL（省略可）※画像サイズはサムネイルサイズに合わせてください
      'no_site_str' => 'ページがなくなった可能性があります。', //metaデータが取得出来なかった時にdiscriptionに表示する文言
      'separation' => ' - ', //タイトルとサイト名の間を区切る文字（ただしOGPタイトルがない場合は対象サイトに合わせる）
      'mysite_name' => false, //タイトル欄に自分のサイト名を付け加えるかどうか
      'ver' => LTG_THUMBLINK_VER, //バージョン情報
      'ogpimg' => '', //ショートコードのプロパティ
      'siteurl' => $url, //ショートコードのプロパティ
      'sitetitle' => '', //ショートコードのプロパティ
      'sitedesc' => '', //ショートコードのプロパティ
      'boxtitle' => '', //ショートコードのプロパティ
      'afphoto' => '',  //ショートコードのプロパティ
      'aflink' => '', //ショートコードのプロパティ
      'card_str' => '0', //ショートコードのプロパティ
      'user_agent' => 'PHP-Lightning-Thumbnail-Link', //繰り返し防止判定に使用
      'reflesh_parameter' => 'ltg-thumb-reflesh', //この名前のパラメーターが付いていると強制的にキャッシュをリフレッシュします
      'theme' => 'Cocoon', //WordPressのテーマを指定（今の所Cocoonのみ対応）
    );

    /* 引数argをconfigに上書き */
    if(is_array($arg)) $this->config = array_merge($this->config,$arg);

    /* 変数変換処理 */
    $this->config['card'] = (trim($this->config['card_str']) == "0" || trim($this->config['card_str']) == '') ? false : true; //boolean型に変更
    $this->config['aflink'] = str_replace(array("\r", "\n","<br>","<br />"), '', $this->config['aflink']);//アフィリエイトリンクの改行を削除（自動変換された<br>も削除） ※規約違反の可能性あり注意
    $this->config['upload_dir'] = WP_CONTENT_DIR.$this->config['dir_cash']; //画像保存場所パス
    $this->config['upload_url'] = WP_CONTENT_URL.$this->config['dir_cash']; //画像保存場所URL
    $this->config['wp_snapshot_prop'] = '?w='.$this->config['thumbnail_width']*$this->config['image_mag'].'&h='.$this->config['thumbnail_height']*$this->config['image_mag']; //スナップショットのサイズ指定



    $this->domain = $this->get_domain($url);//ドメイン取得
    $this->inner_check = $this->check_inout($url); //対象が内部リンクかどうかチェック
  }

  /* 画像をリサイズするメソッド（GDモジュール使用） */
  public function resize_imagejpg($img, $w, $h, $mag = 1){
    /* 画像のサイズを取得 */
    $imgformat = imagecreatefromstring($img);
    $org_w = imagesx($imgformat);
    $org_h = imagesy($imgformat);
    $asp_target = $org_w / $org_h; //アスペクト比
    $asp_thum = $w / $h; //サムネイルのアスペクト比

    /* 画像をリサイズ */
    if($asp_target > $asp_thum){
      $diffW = $org_h * $asp_thum;
      $diffH = $org_h;
      $diffX = ($org_w - $diffW) * 0.5;
      $diffY = 0;
    }elseif($asp_target < $asp_thum){
      $diffW = $org_w;
      $diffH = $org_w / $asp_thum;
      $diffX = 0;
      $diffY = ($org_h - $diffH) * 0.5;
    }elseif($asp_target === $asp_thum){
      $diffW = $org_w;
      $diffH = $org_h;
      $diffX = 0;
      $diffY = 0;
    }

    $thumbnail = imagecreatetruecolor($w * $mag, $h * $mag); //リサイズ先格納場所
    imagefill($thumbnail,0,0,0xFFFFFF);
    $er_image = imagecopyresampled($thumbnail, $imgformat, 0, 0, $diffX, $diffY, $w * $mag, $h * $mag, $diffW, $diffH); //リサイズ＆トリミング
    ob_start();
    imagejpeg($thumbnail, null, 60); //バッファに画像出力
    $image_resized = ob_get_clean(); //リサイズ画像を取得

    $res = array(
      'org_image' => $img,                //オリジナルImage
      'org_width' => $org_w,              //オリジナルImageの横幅
      'org_height' => $org_h,             //オリジナルImageの縦幅
      'resized_image' => $image_resized,  //リサイズ画像Image
      'resized_width' => $w * $mag,       //リサイズ画像Imageの縦幅
      'resized_height' => $h * $mag,      //リサイズ画像Imageの縦幅
    );
    return $res;
  }

  /* キャッシュ書き込みメソッド */
  public function write_cash($url = NULL,$hash = NULL){

    /* 引数が省略されている場合の処理 */
    if($url === NULL){
      if($this->url === NULL) return false;
      $url = $this->url;
    }
    if($hash === NULL) $hash = $this->get_hash($url);

    $ua = $_SERVER['HTTP_USER_AGENT']; //ユーザーエージェントを取得
    if(strpos($ua,$this->config['user_agent']) !== false) return false;

    if($this->config === NULL){ //initされているか判定
      return false;
    } else {
      $config = $this->config;
    }
    $inner_check = $this->inner_check !== NULL ? $this->inner_check : $this->check_inout($url);

    require_once(ABSPATH . 'wp-admin/includes/file.php'); //FILE API読み込み

    /* キャッシュするデータ配列初期化（メモの役割も） */
    $cash = array(
      'url' => $url,                           //ターゲットのURL
      'name' => null,                          //ターゲットのサイト名
      'title' => null,                         //タイトル
      'desc' => null,                          //discription
      'image' => null,                         //OGP image URL（オリジナル）
      'width' => null,                         //OGP image の横幅（オリジナル）
      'height' => null,                        //OGP image の縦幅（オリジナル
      'domain' => $this->domain,               //ターゲットのドメイン
      'cash_img' => null,                      //キャッシュされた画像のURL
      'cash_imgw' => $config['thumbnail_width'] * $config['image_mag'], //キャッシュされた画像の横幅
      'cash_imgh' => $config['thumbnail_height'] * $config['image_mag'],//キャッシュされた画像の縦幅
      'date' => null,                          //投稿日
    );

    $ogp = $this->get_ogp($url,$inner_check); //OGP情報取得

    if($ogp){
      $cash['image'] = $ogp['og_image'] ? $ogp['og_image'] : $ogp['tw_image'];

      if($cash['image'] && ($cash['image'] != '')){
        $img = NULL; //画像格納場所の初期化
        /* 画像読み込み */
        if( WP_Filesystem()){
          global $wp_filesystem;
          $img = $wp_filesystem->get_contents($cash['image']);
        }

        $resized = $this->resize_imagejpg($img,$config['thumbnail_width'],$config['thumbnail_height'],$config['image_mag']); //画像をリサイズ
        $cash['width'] = $resized['org_width'];
        $cash['height'] = $resized['org_height'];

        $image_resized = $resized['resized_image'];

        /* 画像を格納 */
        if (!file_exists($config['upload_dir'])){ //保存ディレクトリが存在しない場合は作成
          mkdir($config['upload_dir'], 0777, true);
        }
        if(WP_Filesystem($image_resized)){
          global $wp_filesystem;
          $wp_filesystem->put_contents($config['upload_dir'].$hash.'.jpg',$image_resized);
          $cash['cash_img'] = $config['upload_url'].$hash.'.jpg';
        } else { //なんらかの理由で格納できない場合はWPスナップショットにする
          $cash['cash_img'] = $config['wp_snapshot_url'].urlencode($url).$config['wp_snapshot_prop'];
        }
      } else { //OGP imageが設定されていなかった場合
        $cash['cash_img'] = $config['wp_snapshot_url'].urlencode($url).$config['wp_snapshot_prop'];
      }
      /* 各種データ代入 */
      $cash['name'] = $ogp['og_sitename'];
      if($inner_check){
        $cash['title'] = $ogp['og_title'] ? $ogp['og_title'].($config['mysite_name'] ? $config['separation'].$ogp['og_sitename'] : '')
        : ($ogp['tw_title'] ? $ogp['tw_title'].($config['mysite_name'] ? $config['separation'].bloginfo('name') : '')
        : $ogp['title']);
      } else {
        $cash['title'] = !$ogp['og_title'] ? $ogp['title']
        : ((strpos($ogp['og_title'],$ogp['og_sitename']) === false) ? $ogp['og_title'].$config['separation'].$ogp['og_sitename'] : $ogp['og_title']); //Twitterカードのタイトル情報はサイト名が入らないので使用しなくした
      }

      $cash['desc'] = $ogp['og_desc'] ? $ogp['og_desc'] : ($ogp['tw_desc'] ? $ogp['tw_desc'] : $ogp['desc']);
      $cash['date'] = $ogp['date'];
    } else { //OGPが取得できなかった場合
      $cash['title'] = $config['sitetitle'];
      $cash['cash_img'] = !empty($config['no_image']) ? $config['no_image'] : $config['wp_snapshot_url'].urlencode($url).$config['wp_snapshot_prop'];
      $cash['desc'] = $config['no_site_str']; //descriptionに注意書きを入れる
    }

    /* キャッシュデータ書き込み */
    set_transient($hash,$cash, $config['cash_period'] * DAY_IN_SECONDS);
    $this->cash = $cash;
    return $cash;
  }

  /* キャッシュ読み込みメソッド */
  public function read_cash($url){
    $hash = $this->get_hash($url); //サイトURLからハッシュ値を算出
    $ogp_cash = get_transient( $hash ); //cashを読み込む
    if($this->config === NULL) $this->init($url); //初期化されていないようならばarg要素なしで初期化

    $config = $this->config;


    if($ogp_cash === false || $ogp_cash['title'] == NULL || ((bool)$_GET[$config['reflesh_parameter']] && current_user_can('edit_user'))||($config['cash_reflesh_mode']) && current_user_can('edit_user')){ //cashが見つからない場合（新規）またはキャッシュ更新モードがtrueの場合
      $ogp_cash = $this->write_cash($url,$hash); //キャッシュ書き込みと情報取得

      if(!$ogp_cash['title']) $ogp_cash['title'] = $config['sitetitle']; //タイトルが取得できなかった場合（ページ消滅？）
    }

    return $ogp_cash;
  }

  /* コンストラクタ */
  public function __construct($url = NULL){
    if($url) $this->url = $url;
  }

}
endif;



/* オブジェクト初期化 */
$target = new Ltg_Thumblink();
$target->init($arg['siteurl'],$arg);

$config = $target->config; //argが追加されたconfig全体を取得
$url = $config['siteurl'];


if($config['card']){ //Cocoonのブログカード機能を使用（ブログカードのフォーマットで出力）
  $func_name = 'lightning_theme_card_'.mb_strtolower(trim($config['theme']));
  if(!function_exists($func_name)) $func_name = 'lightning_theme_card_cocoon';//関数が存在しない場合はCocoon仕様を使う
  $tag_box = $func_name($url);

} else { //サムネイルリンク独自機能使用の場合
  $domain = $target->domain; //ドメイン取得
  $inner_check = $target->inner_check; //内部リンクチェック取得

  $ogp_cash = $target->read_cash($url); //キャッシュ読み込み

  $func_name = 'lightning_tagbox_'.mb_strtolower(trim($config['theme']));
  if(!function_exists($func_name)) $func_name = 'lightning_tagbox_cocoon';//関数が存在しない場合はCocoon仕様を使う
  $tag_box = $func_name($ogp_cash, $config, $inner_check);//タグを作成
}

echo lightning_thumblink_container($tag_box,$config);

 ?>
